<?php

namespace App\Http\Controllers\TherapistCommunitys;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Archive;
use App\Http\Requests\TherapistCommunitys\TherapistCommunityArchives\CreateRequest;
use App\Http\Resources\Web\ArchivesResource;
use Excel;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class TherapistCommunityArchivesController extends Controller
{
    /********* Initialize Permission based Middlewares  ***********/
  public function __construct()
  {
      $this->middleware('auth');
      $this->middleware('therapist_community');
      // $this->middleware('permission:therapist_community_archives.index');
      // $this->middleware('permission:therapist_community_archives.create',['only' => ['store']]);
      // $this->middleware('permission:therapist_community_archives.update',['only' => ['update']]);
      // $this->middleware('permission:therapist_community_archives.delete',['only' => ['destroy']]);
      // $this->middleware('permission:therapist_community_archives.export',['only' => ['export']]);
      // $this->middleware('permission:therapist_community_archives.import',['only' => ['import']])
      // $this->middleware('permission:therapist_community_archives.update|therapist_community_archives.is_active',['only' => ['updateStatus']]);
  }

  /********* Getter For Pagination, Searching And Sorting  ***********/
  public function getter($req = null,$export = null)
  {
    $therapist_community = auth()->user()->therapist_community;
    if($req != null){
      $therapist_community_archives =  $therapist_community->therapist_community_archives()->withAll();
      if($req->trash && $req->trash == 'with'){
        $therapist_community_archives =  $therapist_community_archives->withTrashed();
      }
      if($req->trash && $req->trash == 'only'){
        $therapist_community_archives =  $therapist_community_archives->onlyTrashed();
      }
      if($req->column && $req->column != null && $req->search != null){
          $therapist_community_archives = $therapist_community_archives->whereLike($req->column,$req->search);
        }
       else if($req->search && $req->search != null){

            $therapist_community_archives = $therapist_community_archives->whereLike(['name','description'],$req->search);
        }
      if($req->sort && $req->sort['field'] != null && $req->sort['type'] != null){
          $therapist_community_archives = $therapist_community_archives->OrderBy($req->sort['field'],$req->sort['type']);
      }
      else
      {
        $therapist_community_archives = $therapist_community_archives->OrderBy('id','desc');
      }
      if($export != null){ // for export do not paginate
        $therapist_community_archives = $therapist_community_archives->get();
        return $therapist_community_archives;
      }
      $totalTherapistCommunityArchives = $therapist_community_archives->count();
      $therapist_community_archives = $therapist_community_archives->paginate($req->perPage);
      $therapist_community_archives = ArchivesResource::collection($therapist_community_archives)->response()->getData(true);

      return $therapist_community_archives;
    }
    $therapist_community_archives = ArchivesResource::collection($therapist_community->therapist_community_archives()->withAll()->orderBy('id','desc')->paginate(10))->response()->getData(true);
    return $therapist_community_archives;
  }

  /********* FETCH ALL TherapistCommunityArchives ***********/
    public function index()
    {
        $therapist_community_archives =  $this->getter();
        $response = generateResponse($therapist_community_archives,count($therapist_community_archives['data']) > 0 ? true:false,'TherapistCommunityArchives Fetched Successfully',null,'collection');
        return response()->json($response, 200);
    }

  /********* FILTER TherapistCommunityArchives FOR Search ***********/
   public function filter(Request $request){
     $therapist_community_archives = $this->getter($request);
     $response = generateResponse($therapist_community_archives,count($therapist_community_archives['data']) > 0 ? true:false,'Filter TherapistCommunityArchives Successfully',null,'collection');
     return response()->json($response, 200);
   }

    /********* ADD NEW TherapistCommunityArchive ***********/
    public function store(CreateRequest $request)
    {
      $therapist_community = auth()->user()->therapist_community;
      try{
      DB::beginTransaction();
      $request->merge(['created_by_user_id'=>auth()->user()->id]);
      $data = $request->all();
      $data['image'] = uploadCroppedFile($request,'image','therapist_community_archives');
      $therapist_community_archive = $therapist_community->therapist_community_archives()->create($data);
      $therapist_community_archive->slug = Str::slug($therapist_community_archive->name . ' ' . $therapist_community_archive->id, '-');
      $therapist_community_archive->tags()->sync($request->tag_ids);
      $therapist_community_archive->save();
      $therapist_community_archive = $therapist_community->therapist_community_archives()->withAll()->find($therapist_community_archive->id);
      $therapist_community_archive = new ArchivesResource($therapist_community_archive);
      DB::commit();
    }
      catch (\Exception $e) {
        DB::rollBack();
        request()->session()->flash('alert',['message' => 'Invalid Request','type' => 'error']);
     }
      return redirect()->back();
    }

    /********* View RECORD TO EDIT Or Display ***********/
    public function show( $therapist_community_archive)
    {
        $therapist_community = auth()->user()->therapist_community;
        if($therapist_community_archive->therapist_community_id != $therapist_community->id){
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
        $therapist_community_archive = $therapist_community->therapist_community_archives()->withAll()->find($therapist_community_archive);
        if($therapist_community_archive){
          $therapist_community_archive = new ArchivesResource($therapist_community_archive);
          $response = generateResponse($therapist_community_archive,true,'TherapistCommunityArchive Fetched Successfully',null,'object');
        }
        else{
          $response = generateResponse(null,false,'TherapistCommunityArchive Not FOund',null,'object');
        }
        return response()->json($response, 200);
    }

    /********* UPDATE TherapistCommunityArchive ***********/
    public function update(CreateRequest $request, Archive $therapist_community_archive)
    {
        // dd($request->all());
        $therapist_community = auth()->user()->therapist_community;
        if($therapist_community_archive->therapist_community_id != $therapist_community->id){
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
      try{
        DB::beginTransaction();
        $request->merge(['last_updated_by_user_id'=>auth()->user()->id]);
        $data = $request->all();
        if ($request->image) {
            $data['image'] = uploadCroppedFile($request,'image','therapist_community_archives',$therapist_community_archive->image);
        } else {
            $data['image'] = $therapist_community_archive->image;
        }
        $data['slug'] = Str::slug($data['name'] . ' ' . $therapist_community_archive->id, '-');
        $therapist_community_archive->update($data);
        $therapist_community_archive->tags()->sync($request->tag_ids);
        DB::commit();
      }
        catch (\Exception $e) {
          DB::rollBack();
          request()->session()->flash('alert',['message' => 'Invalid Request','type' => 'error']);
       }
       return redirect()->back();
    }

    /********* UPDATE TherapistCommunityArchive Status***********/
    public function updateStatus(Request $request,Archive $therapist_community_archive){
        $therapist_community = auth()->user()->therapist_community;
        if($therapist_community_archive->therapist_community_id != $therapist_community->id){
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
        $therapist_community_archive->update([
          'is_active' => $therapist_community_archive->is_active == 1 ? 0:1
        ]);
        $response = generateResponse(null,true,'TherapistCommunityArchive Status Updated Successfully',null,'object');
        return response()->json($response, 200);
    }


    /********* DELETE TherapistCommunityArchive ***********/
    public function destroy(Request $request,Archive $therapist_community_archive)
    {
        $therapist_community = auth()->user()->therapist_community;
        if($therapist_community_archive->therapist_community_id != $therapist_community->id){
            request()->session()->flash('alert',['message' => 'Invalid Request','type' => 'error']);
            return redirect()->back();
        }
          if($therapist_community_archive->trashed()) {
            request()->session()->flash('alert',['message' => 'Already in Trash','type' => 'error']);
          }
          else{
            $therapist_community_archive->delete();
          }
          return redirect()->back();
    }
    /*********Permanently DELETE TherapistCommunityArchive ***********/
    public function destroyPermanently(Request $request,$therapist_community_archive)
    {
        $therapist_community= auth()->user()->therapist_community;
        $therapist_community_archive = $therapist_community->therapist_community_archives()->withTrashed()->find($therapist_community_archive);
        if($therapist_community_archive){
            if($therapist_community_archive->therapist_community_id != $therapist_community->id){
                return redirect()->back()->withErrors([
                    'message' => 'Invalid Request',
                    'type' => 'error'
                ]);
            }
          if ($therapist_community_archive->trashed()) {
            $therapist_community_archive->forceDelete();
            $response = generateResponse(null,true,'TherapistCommunityArchive Deleted Successfully',null,'object');
          }
          else{
            $response = generateResponse(null,false,'TherapistCommunityArchive is not in trash to delete permanently',null,'object');
          }
        }
        else{
          $response = generateResponse(null,false,'TherapistCommunityArchive not found',null,'object');
        }
          return response()->json($response, 200);
    }
    /********* Restore TherapistCommunityArchive ***********/
    public function restore(Request $request,$therapist_community_archive)
    {
      $therapist_community= auth()->user()->therapist_community;
      $therapist_community_archive = $therapist_community->therapist_community_archives()->withTrashed()->find($therapist_community_archive);
          if ($therapist_community_archive->trashed()) {
            $therapist_community_archive->restore();
            $response = generateResponse(null,true,'TherapistCommunityArchive Restored Successfully',null,'object');
          }
          else{
            $response = generateResponse(null,false,'TherapistCommunityArchive is not trashed',null,'object');
          }
          return response()->json($response, 200);
    }
}
